<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Astra
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

get_header(); ?>

<div id="primary" <?php astra_primary_class(); ?>>

    <?php astra_primary_content_top(); ?>

    <div class="custom-404">
        <h1>Oops! Page non trouvée</h1>
        <p>La page que vous cherchez n'existe pas ou a été déplacée.</p>
        <?php 
        // ID de l'image dans les médias
        $image_id = 2456; 
        $image_url = wp_get_attachment_image_url( $image_id, 'full' ); 
        if ( $image_url ) : ?>
            <img src="<?php echo esc_url( $image_url ); ?>" alt="Image de la page 404" style="max-width: 100%; height: auto;">
        <?php endif; ?>
    </div>

    <?php astra_primary_content_bottom(); ?>

</div><!-- #primary -->

<?php get_footer(); ?>
